/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.perfhook;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpManager.AppletNotifyInterface;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.Service;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.TimeTicks;
import ibm.nways.jdm.snmp.SnmpAPI;
import ibm.nways.jdm.snmp.SnmpTrap;
import ibm.nways.jdm.snmp.SnmpTrapSession;
import ibm.nways.perfhook.PerfService;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class ModelListener
extends UnicastRemoteObject
implements Service,
AppletNotifyInterface {
    SnmpTrapSession session;
    OID enterprise = new OID("1.3.6.1.4.1.2.6.141.1.1");
    OID timestamp = new OID("1.3.6.1.4.1.2.6.141.2.1.1.0");
    OID timestamp2 = new OID("1.3.6.1.4.1.2.6.141.2.1.2.0");
    OID resource = new OID("1.3.6.1.4.1.2.6.141.2.1.3.0");
    OctetString defaultCommunity = new OctetString("public", true);
    TimeTicks defaultTime = new TimeTicks(0L);
    String[] ids;
    SimpleTimeZone gmt;

    public void start() {
        try {
            SnmpAPI.initialize();
            this.session = SnmpTrapSession.open((String)InetAddress.getLocalHost().getHostAddress());
            this.ids = TimeZone.getAvailableIDs(0);
            this.gmt = new SimpleTimeZone(0, this.ids[0]);
            PerfService perfService = (PerfService)JdmServerImpl.getSingleton().getService("PollingService");
            perfService.registerForEvents(this);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void shutdown() {
        PerfService perfService = (PerfService)JdmServerImpl.getSingleton().getService("PollingService");
        try {
            perfService.unregisterForEvents(this);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getName() {
        return "EventListener";
    }

    public void updateEvent(Vector vector) throws RemoteException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.gmt);
        gregorianCalendar.get(11);
        int n = 0;
        while (n < vector.size()) {
            PerformanceEvent performanceEvent = (PerformanceEvent)vector.elementAt(n);
            SnmpTrap snmpTrap = new SnmpTrap();
            snmpTrap.enterprise = this.enterprise;
            snmpTrap.communityString = this.defaultCommunity;
            snmpTrap.timeStamp = this.defaultTime;
            snmpTrap.genericTrap = 6;
            snmpTrap.specificTrap = performanceEvent.getCause();
            snmpTrap.agentAddr = new IPAddress(performanceEvent.getHostname());
            long l = performanceEvent.getEventTime();
            byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            gregorianCalendar.setTime(new Date(l));
            int n2 = gregorianCalendar.get(1);
            int n3 = gregorianCalendar.get(14);
            byArray[0] = (byte)(n2 >> 8);
            byArray[1] = (byte)(n2 & 0xFF);
            byArray[2] = (byte)(gregorianCalendar.get(2) + 1);
            byArray[3] = (byte)gregorianCalendar.get(5);
            byArray[4] = (byte)gregorianCalendar.get(11);
            byArray[5] = (byte)gregorianCalendar.get(12);
            byArray[6] = (byte)gregorianCalendar.get(13);
            byArray[7] = (byte)(n3 / 100);
            snmpTrap.addVarBind(this.timestamp, (Serializable)new OctetString(byArray));
            Date date = new Date(l);
            OctetString octetString = new OctetString(date.toString(), true);
            snmpTrap.addVarBind(this.timestamp2, (Serializable)octetString);
            String string = performanceEvent.getIdentifier();
            Vector vector2 = performanceEvent.getHistory();
            if (vector2 != null && vector2.size() > 0) {
                String string2 = null;
                DataPoint dataPoint = (DataPoint)vector2.elementAt(0);
                string2 = dataPoint.getID();
                if (string2 != null && string2.length() > 0) {
                    string = String.valueOf(string) + "." + string2;
                }
            }
            snmpTrap.addVarBind(this.resource, (Serializable)new OctetString(string, true));
            try {
                this.session.send(snmpTrap);
            }
            catch (Exception exception) {}
            ++n;
        }
    }
}

